//AIM:Compute the numerical aperture and the critical angle at the core 
//cladding interface for the step index fiber

//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Let the acceptance angle in air be 22 degrees and a relative refractive index 
//difference of 3%
theta_a_degrees=22;
theta_a_radians=(theta_a_degrees)*(%pi/180);
del=0.03;
NA=sin(theta_a_radians);
disp(NA,'NA=')
n1=(NA)/(sqrt(2*del));
disp(n1,'n1=')
//Computing n2:
n2=n1-(del*n1);
disp(n2,'n2=')
//Computing the critical angle
fiy_c=asin(n2/n1);
fiy_c_degrees=(fiy_c)*(180/%pi);
disp('degrees',fiy_c_degrees,'Critical angle=')
